use "${tmp}/Regfile_nafZE", clear

drop E_* HE* EP*_* _merge

	rename mainlabex labexid

	merge m:1 labexid using "${tmp}/main_labex_with_ctrf", nogen keep(1 3) keepusing(dotation* note_* accept) 
	rename accept max_accept
	drop if ape == ""
	rename note_totale max_note
	xtset gp year
	sort gp year
	gen max_note30 = max_note >= 30
	gen tx = log(job_eng_sbrut / L.job_eng_sbrut)
	winsor2 tx, by(year) cuts(1 99) replace 
	bys ape ZE2010: egen sum_nonmi = sum((tx!=.)*(year > 2010))
	bys ape ZE2010: egen tx_post = sum(tx*(year > 2010)/sum_nonmi)	
	drop sum_nonmi
	bys ape ZE2010: egen sum_nonmi = sum((tx!=.)*(year <= 2010))
	bys ape ZE2010: egen tx_pre = sum(tx*(year <= 2010)/sum_nonmi)	
	drop sum_nonmi	
	cap drop _merge
	
	
	sort gp year
	
	gen max_note_r =round(max_note)
	qui tab max_note_r, gen(e_)
	
	reg max_accept max_note30  if year == 2010 , vce(cluster labexid)
	keep if e(sample)

	gen notenot29 = floor(max_note) != 29

	egen ge = group(ape ZE2010)
	
	preserve
		gen ub = .
		gen lb = .
		gen coef = .
		reghdfe tx_post max_note30 if year == 2010 & share_exposure_maxlabex > .0 &   !inrange(max_note, 29.51, 30.49) & inrange(max_note, 28.51, 31.5) , vce(cluster labexid) noabsorb
		replace coef =  _b[max_note30] in 1
		replace ub = _b[max_note30] + 1.96*_se[max_note30] in 1
		replace lb = _b[max_note30] - 1.96*_se[max_note30] in 1
		
		reghdfe tx_post max_note30 if year == 2010 & share_exposure_maxlabex > .5 &   !inrange(max_note, 29.51, 30.49) & inrange(max_note, 28.51, 31.5) , vce(cluster labexid) noabsorb
		replace coef =  _b[max_note30] in 5
		replace ub = _b[max_note30] + 1.96*_se[max_note30] in 5
		replace lb = _b[max_note30] - 1.96*_se[max_note30] in 5
		
		reghdfe tx_post max_note30 if year == 2010 & share_exposure_maxlabex > .90 &   !inrange(max_note, 29.51, 30.49) & inrange(max_note, 28.51, 31.5) , vce(cluster labexid) noabsorb
		replace coef =  _b[max_note30] in 6
		replace ub = _b[max_note30] + 1.96*_se[max_note30] in 6
		replace lb = _b[max_note30] - 1.96*_se[max_note30] in 6
		
		reghdfe tx_post max_note30 if year == 2010 & share_exposure_maxlabex > .0 &   inrange(max_note, 28.51, 31.5) , vce(cluster labexid) noabsorb
		replace coef =  _b[max_note30] in 9
		replace ub = _b[max_note30] + 1.96*_se[max_note30] in 9
		replace lb = _b[max_note30] - 1.96*_se[max_note30] in 9
		
		reghdfe tx_post max_note30 if year == 2010 & share_exposure_maxlabex > .0 &    !inrange(max_note, 29.51, 30.49) & inrange(max_note, 28.51, 32.5) , vce(cluster labexid) noabsorb	
		replace coef =  _b[max_note30] in 12
		replace ub = _b[max_note30] + 1.96*_se[max_note30] in 12
		replace lb = _b[max_note30] - 1.96*_se[max_note30] in 12
		
		reghdfe tx_post max_note30 if year == 2010 & share_exposure_maxlabex > .0 &    !inrange(max_note, 29.51, 30.49) & inrange(max_note, 28.51, 33.5) , vce(cluster labexid) noabsorb	
		replace coef =  _b[max_note30] in 13
		replace ub = _b[max_note30] + 1.96*_se[max_note30] in 13
		replace lb = _b[max_note30] - 1.96*_se[max_note30] in 13
		
		reghdfe tx_post max_note30 if year == 2010 & share_exposure_maxlabex > .0 &    !inrange(max_note, 29.51, 30.49) & inrange(max_note, 28.51, 34.5) , vce(cluster labexid) noabsorb	
		replace coef =  _b[max_note30] in 14
		replace ub = _b[max_note30] + 1.96*_se[max_note30] in 14
		replace lb = _b[max_note30] - 1.96*_se[max_note30] in 14
		
		reghdfe tx_post max_note30 if year == 2010 & share_exposure_maxlabex > .0 &    !inrange(max_note, 29.51, 30.49) & inrange(max_note, 28.51, 35.5) , vce(cluster labexid) noabsorb	
		replace coef =  _b[max_note30] in 15
		replace ub = _b[max_note30] + 1.96*_se[max_note30] in 15
		replace lb = _b[max_note30] - 1.96*_se[max_note30] in 15
		
		reghdfe tx_post max_note30 if year == 2010 & share_exposure_maxlabex > .0 &   !inrange(max_note, 29.51, 30.49) & inrange(max_note, 28.51, 31.5) , vce(cluster ge) noabsorb
		replace coef =  _b[max_note30] in 18
		replace ub = _b[max_note30] + 1.96*_se[max_note30] in 18
		replace lb = _b[max_note30] - 1.96*_se[max_note30] in 18
		
		reghdfe tx_post max_note30 if year == 2010 & share_exposure_maxlabex > .0 &   !inrange(max_note, 29.51, 30.49) & inrange(max_note, 28.51, 31.5) , vce(cluster ZE2010) noabsorb
		replace coef =  _b[max_note30] in 19
		replace ub = _b[max_note30] + 1.96*_se[max_note30] in 19
		replace lb = _b[max_note30] - 1.96*_se[max_note30] in 19
			gen n = _n

		keep if ub != .
		keep ub lb coef n
		local N = _N+1
		set obs `N'
		replace n = -1 if n == .
		tsset n
		tsfill, full
		gen label = ""
		replace label = "Baseline" if n == 1
		replace label = "Only strong links" if n == 5
		replace label = "Including grade 30" if n == 9
		replace label = "Broader grade window" if n == 13
		replace label = "Alternative clustering" if n == 18
		labmask n, values(label)
		gen yup = .1
		gen ylo = -.1
		twoway (rcap ub lb n if n != 1 ) (rcap ub lb n if n ==1, yline(0) ylab(-.1(0.05).1, nogrid) xlab(1 5  9  13  18 , valuelabels angle(20) nogrid ) ) (scatter coef n if n !=1,  mcol(navy red) mlcol(black black)) (scatter coef n if n == 1) ///
		(rarea yup ylo n if inrange(n, 0, 2), color(red%15) lcolor(red%15)), legend(off) yscale(fextend) xscale(fextend) xtitle("") xscale(range(0 19)) ytitle("") yscale(range(-.1 .1))
		graph export  "${outpath}/Figure3a.pdf", as(pdf) replace

	restore

	
	preserve
		gen ub = .
		gen lb = .
		gen coef = .
		reghdfe tx_pre max_note30 if year == 2010 & share_exposure_maxlabex > .0 &   !inrange(max_note, 29.51, 30.49) & inrange(max_note, 28.51, 31.5) , vce(cluster labexid) noabsorb
		replace coef =  _b[max_note30] in 1
		replace ub = _b[max_note30] + 1.96*_se[max_note30] in 1
		replace lb = _b[max_note30] - 1.96*_se[max_note30] in 1
		
		reghdfe tx_pre max_note30 if year == 2010 & share_exposure_maxlabex > .5 &   !inrange(max_note, 29.51, 30.49) & inrange(max_note, 28.51, 31.5) , vce(cluster labexid) noabsorb
		replace coef =  _b[max_note30] in 5
		replace ub = _b[max_note30] + 1.96*_se[max_note30] in 5
		replace lb = _b[max_note30] - 1.96*_se[max_note30] in 5
		
		reghdfe tx_pre max_note30 if year == 2010 & share_exposure_maxlabex > .90 &   !inrange(max_note, 29.51, 30.49) & inrange(max_note, 28.51, 31.5) , vce(cluster labexid) noabsorb
		replace coef =  _b[max_note30] in 6
		replace ub = _b[max_note30] + 1.96*_se[max_note30] in 6
		replace lb = _b[max_note30] - 1.96*_se[max_note30] in 6
		
		reghdfe tx_pre max_note30 if year == 2010 & share_exposure_maxlabex > .0 &   inrange(max_note, 28.51, 31.5) , vce(cluster labexid) noabsorb
		replace coef =  _b[max_note30] in 9
		replace ub = _b[max_note30] + 1.96*_se[max_note30] in 9
		replace lb = _b[max_note30] - 1.96*_se[max_note30] in 9
		
		reghdfe tx_pre max_note30 if year == 2010 & share_exposure_maxlabex > .0 &    !inrange(max_note, 29.51, 30.49) & inrange(max_note, 28.51, 32.5) , vce(cluster labexid) noabsorb	
		replace coef =  _b[max_note30] in 12
		replace ub = _b[max_note30] + 1.96*_se[max_note30] in 12
		replace lb = _b[max_note30] - 1.96*_se[max_note30] in 12
		
		reghdfe tx_pre max_note30 if year == 2010 & share_exposure_maxlabex > .0 &    !inrange(max_note, 29.51, 30.49) & inrange(max_note, 28.51, 33.5) , vce(cluster labexid) noabsorb	
		replace coef =  _b[max_note30] in 13
		replace ub = _b[max_note30] + 1.96*_se[max_note30] in 13
		replace lb = _b[max_note30] - 1.96*_se[max_note30] in 13
		
		reghdfe tx_pre max_note30 if year == 2010 & share_exposure_maxlabex > .0 &    !inrange(max_note, 29.51, 30.49) & inrange(max_note, 28.51, 34.5) , vce(cluster labexid) noabsorb	
		replace coef =  _b[max_note30] in 14
		replace ub = _b[max_note30] + 1.96*_se[max_note30] in 14
		replace lb = _b[max_note30] - 1.96*_se[max_note30] in 14
		
		reghdfe tx_pre max_note30 if year == 2010 & share_exposure_maxlabex > .0 &    !inrange(max_note, 29.51, 30.49) & inrange(max_note, 28.51, 35.5) , vce(cluster labexid) noabsorb	
		replace coef =  _b[max_note30] in 15
		replace ub = _b[max_note30] + 1.96*_se[max_note30] in 15
		replace lb = _b[max_note30] - 1.96*_se[max_note30] in 15
		
		reghdfe tx_pre max_note30 if year == 2010 & share_exposure_maxlabex > .0 &   !inrange(max_note, 29.51, 30.49) & inrange(max_note, 28.51, 31.5) , vce(cluster ge) noabsorb
		replace coef =  _b[max_note30] in 18
		replace ub = _b[max_note30] + 1.96*_se[max_note30] in 18
		replace lb = _b[max_note30] - 1.96*_se[max_note30] in 18
		
		reghdfe tx_pre max_note30 if year == 2010 & share_exposure_maxlabex > .0 &   !inrange(max_note, 29.51, 30.49) & inrange(max_note, 28.51, 31.5) , vce(cluster ZE2010) noabsorb
		replace coef =  _b[max_note30] in 19
		replace ub = _b[max_note30] + 1.96*_se[max_note30] in 19
		replace lb = _b[max_note30] - 1.96*_se[max_note30] in 19
			gen n = _n

		keep if ub != .
		keep ub lb coef n
		local N = _N+1
		set obs `N'
		replace n = -1 if n == .
		tsset n
		tsfill, full
		gen label = ""
		replace label = "Baseline" if n == 1
		replace label = "Only strong links" if n == 5
		replace label = "Including grade 30" if n == 9
		replace label = "Broader grade window" if n == 13
		replace label = "Alternative clustering" if n == 18
		labmask n, values(label)
		gen yup = .1
		gen ylo = -.1
		twoway (rcap ub lb n if n != 1, ) (rcap ub lb n if n ==1, yline(0) ylab(-.1(0.05).1, nogrid) xlab(1 5  9  13  18 , valuelabels angle(20) nogrid ) ) (scatter coef n if n !=1,  mcol(navy red) mlcol(black black)) (scatter coef n if n == 1) ///
		(rarea yup ylo n if inrange(n, 0, 2), color(red%15) lcolor(red%15)), legend(off) yscale(fextend) xscale(fextend) xtitle("") xscale(range(0 19)) ytitle("") yscale(range(-.1 .10))
		graph export  "${outpath}/Figure3b.pdf", as(pdf) replace

	restore
